/*
 * Decompiled with CFR 0.152.
 */
package cz.snyll.sunny.controllers;

import cz.snyll.sunny.convenience.NicePrinter;
import cz.snyll.sunny.domain.SmartInverterAutomation;
import cz.snyll.sunny.domain.inverter.CloudApiDetails;
import cz.snyll.sunny.domain.inverter.ConnectionDetails;
import cz.snyll.sunny.domain.inverter.Inverter;
import cz.snyll.sunny.domain.inverter.LocalAPIDetails;
import cz.snyll.sunny.domain.inverter.ModbusRTUDetails;
import cz.snyll.sunny.domain.inverter.ModbusTCPDetails;
import cz.snyll.sunny.repositories.InverterRepository;
import cz.snyll.sunny.repositories.SmartInverterAutomationRepository;
import cz.snyll.sunny.services.InverterManagerService;
import cz.snyll.sunny.services.collectors.collectorfactories.InverterCollectorFactory;
import jakarta.transaction.Transactional;
import jakarta.validation.Valid;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestParam;

@Controller
public class InverterController {
    private final InverterManagerService inverterManagerService;
    private final InverterRepository inverterRepository;
    private final SmartInverterAutomationRepository smartInverterAutomationRepository;

    @Autowired
    public InverterController(InverterManagerService inverterManagerService, InverterRepository inverterRepository, SmartInverterAutomationRepository smartInverterAutomationRepository) {
        this.inverterManagerService = inverterManagerService;
        this.inverterRepository = inverterRepository;
        this.smartInverterAutomationRepository = smartInverterAutomationRepository;
    }

    @GetMapping(value={"/inverter"})
    public String inverter(Model model, @RequestParam(required=false) Long id) {
        Inverter inverter;
        if (id == null) {
            id = 0L;
        }
        if ((inverter = this.inverterRepository.findById((Object)id).orElseGet(Inverter::new)).getConnectionDetails() == null) {
            inverter.setConnectionDetails((ConnectionDetails)new LocalAPIDetails());
        }
        model.addAttribute("connectionMethods", (Object)InverterCollectorFactory.ConnectionMethod.values());
        model.addAttribute("inverter", (Object)inverter);
        return "inverter";
    }

    @PostMapping(value={"/inverter"})
    public String inverterSubmit(@Valid @ModelAttribute Inverter inverter, BindingResult result, Model model, @RequestParam(required=false) String connectionDetailsCommunicationType, @RequestParam(required=false) String connectionDetailsLocalApiIp, @RequestParam(required=false) String connectionDetailsLocalApiPassword, @RequestParam(required=false) String connectionDetailsLocalApiTokenId, @RequestParam(required=false) String connectionDetailsDevicePath, @RequestParam(required=false) Integer connectionDetailsBaudRate, @RequestParam(required=false) Integer connectionDetailsDataBits, @RequestParam(required=false) Integer connectionDetailsStopBits, @RequestParam(required=false) String connectionDetailsParity, @RequestParam(required=false) String connectionDetailsEncoding, @RequestParam(required=false) String connectionDetailsIp, @RequestParam(required=false) Integer connectionDetailsPort, @RequestParam(required=false) String connectionDetailsCloudUrl, @RequestParam(required=false) String connectionDetailsCloudApiKey, @RequestParam(required=false) String connectionDetailsWifiDongleCode) {
        try {
            switch (connectionDetailsCommunicationType) {
                case "LocalAPI": {
                    ConnectionDetails connectionDetails = inverter.getConnectionDetails();
                    if (connectionDetails instanceof LocalAPIDetails) {
                        LocalAPIDetails existingLocalAPIDetails = (LocalAPIDetails)connectionDetails;
                        existingLocalAPIDetails.setIp(connectionDetailsLocalApiIp);
                        existingLocalAPIDetails.setLocalPassword(connectionDetailsLocalApiPassword);
                        existingLocalAPIDetails.setTokenId(connectionDetailsLocalApiTokenId);
                        break;
                    }
                    LocalAPIDetails localAPIDetails = new LocalAPIDetails();
                    localAPIDetails.setIp(connectionDetailsLocalApiIp);
                    localAPIDetails.setLocalPassword(connectionDetailsLocalApiPassword);
                    localAPIDetails.setTokenId(connectionDetailsLocalApiTokenId);
                    inverter.setConnectionDetails((ConnectionDetails)localAPIDetails);
                    break;
                }
                case "ModbusRTU": {
                    ConnectionDetails localAPIDetails = inverter.getConnectionDetails();
                    if (localAPIDetails instanceof ModbusRTUDetails) {
                        ModbusRTUDetails existingModbusRTUDetails = (ModbusRTUDetails)localAPIDetails;
                        existingModbusRTUDetails.setDevicePath(connectionDetailsDevicePath);
                        existingModbusRTUDetails.setBaudRate(connectionDetailsBaudRate.intValue());
                        existingModbusRTUDetails.setDataBits(connectionDetailsDataBits.intValue());
                        existingModbusRTUDetails.setStopBits(connectionDetailsStopBits.intValue());
                        existingModbusRTUDetails.setParity(connectionDetailsParity);
                        existingModbusRTUDetails.setEncoding(connectionDetailsEncoding);
                        break;
                    }
                    ModbusRTUDetails modbusRTUDetails = new ModbusRTUDetails();
                    modbusRTUDetails.setDevicePath(connectionDetailsDevicePath);
                    modbusRTUDetails.setBaudRate(connectionDetailsBaudRate.intValue());
                    modbusRTUDetails.setDataBits(connectionDetailsDataBits.intValue());
                    modbusRTUDetails.setStopBits(connectionDetailsStopBits.intValue());
                    modbusRTUDetails.setParity(connectionDetailsParity);
                    modbusRTUDetails.setEncoding(connectionDetailsEncoding);
                    inverter.setConnectionDetails((ConnectionDetails)modbusRTUDetails);
                    break;
                }
                case "ModbusTCP": {
                    ConnectionDetails modbusRTUDetails = inverter.getConnectionDetails();
                    if (modbusRTUDetails instanceof ModbusTCPDetails) {
                        ModbusTCPDetails existingModbusTCPDetails = (ModbusTCPDetails)modbusRTUDetails;
                        existingModbusTCPDetails.setIp(connectionDetailsIp);
                        existingModbusTCPDetails.setPort(connectionDetailsPort.intValue());
                        break;
                    }
                    ModbusTCPDetails modbusTCPDetails = new ModbusTCPDetails();
                    modbusTCPDetails.setIp(connectionDetailsIp);
                    modbusTCPDetails.setPort(connectionDetailsPort.intValue());
                    inverter.setConnectionDetails((ConnectionDetails)modbusTCPDetails);
                    break;
                }
                case "CloudAPI": {
                    ConnectionDetails modbusTCPDetails = inverter.getConnectionDetails();
                    if (modbusTCPDetails instanceof CloudApiDetails) {
                        CloudApiDetails existingCloudApiDetails = (CloudApiDetails)modbusTCPDetails;
                        existingCloudApiDetails.setCloudUrl(connectionDetailsCloudUrl);
                        existingCloudApiDetails.setCloudApiKey(connectionDetailsCloudApiKey);
                        existingCloudApiDetails.setWifiDongleCode(connectionDetailsWifiDongleCode);
                        break;
                    }
                    CloudApiDetails cloudAPIDetails = new CloudApiDetails();
                    cloudAPIDetails.setCloudUrl(connectionDetailsCloudUrl);
                    cloudAPIDetails.setCloudApiKey(connectionDetailsCloudApiKey);
                    cloudAPIDetails.setWifiDongleCode(connectionDetailsWifiDongleCode);
                    inverter.setConnectionDetails((ConnectionDetails)cloudAPIDetails);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unsupported connection method: " + connectionDetailsCommunicationType);
                }
            }
            NicePrinter.nicePrint((String)("Inverter: " + inverter), (String)"true");
            model.addAttribute("inverter", (Object)inverter);
            model.addAttribute("connectionMethods", (Object)InverterCollectorFactory.ConnectionMethod.values());
            if (result.hasErrors()) {
                return "inverter";
            }
            this.inverterManagerService.saveInverter(inverter);
            model.addAttribute("success", (Object)true);
            return "redirect:/inverterlist?success=true";
        }
        catch (Exception e) {
            e.printStackTrace();
            return "redirect:/inverterlist?success=false";
        }
    }

    @GetMapping(value={"/inverter/edit"})
    @Transactional
    public String inverterEdit(Model model, @RequestParam(required=false) Long id, @RequestParam(required=false) boolean delete) {
        if (delete && id != null && id > 0L) {
            Optional inverterOpt = this.inverterRepository.findById((Object)id);
            if (inverterOpt.isPresent()) {
                Inverter inverter = (Inverter)inverterOpt.get();
                if (inverter.getAppliedAutomations() != null) {
                    for (SmartInverterAutomation automation : inverter.getAppliedAutomations()) {
                        automation.getInvertersApplied().remove(inverter);
                        this.smartInverterAutomationRepository.save((Object)automation);
                    }
                    inverter.getAppliedAutomations().clear();
                }
                this.inverterRepository.delete((Object)inverter);
            }
            return "redirect:../inverterlist?deletesuccess=true";
        }
        return "redirect:../inverterlist?deletesuccess=false";
    }
}

