/*
 * Decompiled with CFR 0.152.
 */
package cz.snyll.sunny.controllers;

import cz.snyll.sunny.domain.InverterAction;
import cz.snyll.sunny.repositories.InverterActionRepository;
import cz.snyll.sunny.services.DeviceSettingManagerService;
import cz.snyll.sunny.services.InverterActionServiceManager;
import cz.snyll.sunny.services.InverterManagerService;
import jakarta.validation.Valid;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestParam;

@Controller
public class InverterActionController {
    private final InverterActionRepository inverterActionRepository;
    private final InverterActionServiceManager inverterActionServiceManager;
    private final DeviceSettingManagerService deviceSettingManagerService;
    private final InverterManagerService inverterManagerService;

    @Autowired
    public InverterActionController(InverterActionRepository inverterActionRepository, InverterActionServiceManager inverterActionServiceManager, DeviceSettingManagerService deviceSettingManagerService, InverterManagerService inverterManagerService) {
        this.inverterActionRepository = inverterActionRepository;
        this.inverterActionServiceManager = inverterActionServiceManager;
        this.deviceSettingManagerService = deviceSettingManagerService;
        this.inverterManagerService = inverterManagerService;
    }

    @GetMapping(value={"/inverteraction"})
    public String inverterAction(Model model, @RequestParam(required=false) Long id) {
        if (id == null) {
            id = 0L;
        }
        InverterAction inverterAction = this.inverterActionRepository.findById((Object)id).orElseGet(InverterAction::new);
        model.addAttribute("devicesettings", (Object)this.deviceSettingManagerService.loadAll());
        model.addAttribute("inverters", (Object)this.inverterManagerService.loadAll());
        model.addAttribute("inverterAction", (Object)inverterAction);
        return "inverteraction";
    }

    @GetMapping(value={"/inverteraction/edit"})
    public String inverterActionEdit(Model model, @RequestParam(required=false) Long id, @RequestParam(required=false) boolean delete) {
        model.addAttribute("devicesettings", (Object)this.deviceSettingManagerService.loadAll());
        model.addAttribute("inverters", (Object)this.inverterManagerService.loadAll());
        if (delete && id > 0L) {
            this.inverterActionServiceManager.deleteInverterActionById(id);
            return "redirect:../inverteractionlist?deletesuccess=true";
        }
        return "redirect:../inverteractionlist?deletesuccess=false";
    }

    @PostMapping(value={"/inverteraction"})
    public String inverterActionSubmit(@Valid @ModelAttribute(value="inverterAction") InverterAction inverterAction, BindingResult result, Model model) {
        model.addAttribute("inverterAction", (Object)inverterAction);
        model.addAttribute("devicesettings", (Object)this.deviceSettingManagerService.loadAll());
        model.addAttribute("inverters", (Object)this.inverterManagerService.loadAll());
        if (result.hasErrors()) {
            return "inverteraction";
        }
        this.inverterActionServiceManager.saveInverterAction(inverterAction);
        model.addAttribute("success", (Object)true);
        return "redirect:/inverteractionlist?success=true";
    }
}

