/*
 * Decompiled with CFR 0.152.
 */
package cz.snyll.sunny.controllers;

import cz.snyll.sunny.domain.DailyRecord;
import cz.snyll.sunny.domain.GroupedDailyRecords;
import cz.snyll.sunny.repositories.DailyRecordRepository;
import cz.snyll.sunny.repositories.GroupedDailyRecordsRepository;
import java.time.LocalDate;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class GetDailyRecordsController {
    @Autowired
    private DailyRecordRepository dailyRecordRepository;
    @Autowired
    private GroupedDailyRecordsRepository groupedDailyRecordsRepository;

    @RequestMapping(value={"/getdailyrecords"}, method={RequestMethod.GET}, params={"groupBy"})
    public List<GroupedDailyRecords> getDailyRecordsWithGroupBy(Model model, @RequestParam(required=true) LocalDate startDate, @RequestParam(required=true) LocalDate endDate, @RequestParam(required=true) String groupBy) {
        List results = null;
        if (groupBy.equals("year")) {
            results = this.groupedDailyRecordsRepository.findAllGroupedByYear(startDate, endDate);
        } else if (groupBy.equals("month")) {
            results = this.groupedDailyRecordsRepository.findAllGroupedByMonth(startDate, endDate);
        }
        return results;
    }

    @RequestMapping(value={"/getdailyrecords"}, method={RequestMethod.GET})
    public List<DailyRecord> getDailyRecords(Model model, @RequestParam(required=true) LocalDate startDate, @RequestParam(required=true) LocalDate endDate) {
        List results = this.dailyRecordRepository.findAllByDateBetweenOrderByDateAsc(startDate, endDate);
        return results;
    }
}

