/*
 * Decompiled with CFR 0.152.
 */
package cz.snyll.sunny.controllers;

import cz.snyll.sunny.services.database.ConfigurationExportImportService;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Arrays;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.io.PathResource;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
public class ExportdbController {
    @Autowired
    private ConfigurationExportImportService configService;
    private static final String EXPORT_DIR = "./data/config_exports/";

    @GetMapping(value={"/exportdb"})
    public ResponseEntity<?> exportConfiguration() {
        try {
            Files.createDirectories(Paths.get(EXPORT_DIR, new String[0]), new FileAttribute[0]);
            LocalDateTime now = LocalDateTime.now();
            DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd_HH-mm-ss");
            String formattedDateTime = now.format(formatter);
            String filename = "sunnyhome_config_" + formattedDateTime + ".json";
            Path filePath = Paths.get(EXPORT_DIR, filename);
            this.configService.exportConfiguration(filePath.toString());
            PathResource resource = new PathResource(filePath);
            if (!resource.exists()) {
                return ResponseEntity.status((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR).body((Object)"Export failed: generated file not found");
            }
            return ((ResponseEntity.BodyBuilder)((ResponseEntity.BodyBuilder)((ResponseEntity.BodyBuilder)ResponseEntity.ok().header("Content-Disposition", new String[]{"attachment; filename=\"" + filename + "\""})).header("Content-Type", new String[]{"application/json"})).header("Content-Length", new String[]{String.valueOf(resource.contentLength())})).body((Object)resource);
        }
        catch (IOException e) {
            return ResponseEntity.status((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR).body((Object)("Export failed: " + e.getMessage()));
        }
    }

    @PostMapping(value={"/importdb"})
    public String importConfiguration(@RequestParam(value="file") MultipartFile file, @RequestParam(value="clearExisting", defaultValue="true") boolean clearExisting) {
        if (file.isEmpty()) {
            return "No file uploaded";
        }
        try {
            Files.createDirectories(Paths.get("./data/temp/", new String[0]), new FileAttribute[0]);
            String tempFilepath = "./data/temp/import_" + System.currentTimeMillis() + ".json";
            Path tempPath = Paths.get(tempFilepath, new String[0]);
            Files.write(tempPath, file.getBytes(), new OpenOption[0]);
            this.configService.importConfiguration(tempFilepath, clearExisting);
            Files.deleteIfExists(tempPath);
            return "ok";
        }
        catch (Exception e) {
            return "Import failed: " + e.getMessage();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @GetMapping(value={"/importdb"})
    public String importConfigurationLegacy(@RequestParam(required=false) String file) {
        try {
            Object filepath;
            if (file != null && !file.isEmpty()) {
                filepath = "./data/" + file;
            } else {
                Path exportPath = Paths.get(EXPORT_DIR, new String[0]);
                if (!Files.exists(exportPath, new LinkOption[0])) return "No export directory found";
                File[] files = exportPath.toFile().listFiles((dir, name) -> name.endsWith(".json"));
                if (files == null || files.length <= 0) return "No configuration files found to import";
                Arrays.sort(files, (a, b) -> Long.compare(b.lastModified(), a.lastModified()));
                filepath = files[0].getAbsolutePath();
            }
            this.configService.importConfiguration((String)filepath, true);
            return "ok";
        }
        catch (Exception e) {
            return e.getMessage();
        }
    }

    @GetMapping(value={"/configinfo"})
    public String getConfigurationInfo() {
        try {
            File[] files;
            Path exportPath = Paths.get(EXPORT_DIR, new String[0]);
            if (Files.exists(exportPath, new LinkOption[0]) && (files = exportPath.toFile().listFiles((dir, name) -> name.endsWith(".json"))) != null && files.length > 0) {
                StringBuilder info = new StringBuilder("Available configuration files:\\n");
                for (File file : files) {
                    info.append("- ").append(file.getName()).append(" (").append(file.length()).append(" bytes)\\n");
                }
                return info.toString();
            }
            return "No configuration files available";
        }
        catch (Exception e) {
            return "Failed to get configuration info: " + e.getMessage();
        }
    }
}

