/*
 * Decompiled with CFR 0.152.
 */
package cz.snyll.sunny.controllers;

import cz.snyll.sunny.domain.EmailNotification;
import cz.snyll.sunny.repositories.NotificationRepository;
import cz.snyll.sunny.services.DeviceSettingManagerService;
import cz.snyll.sunny.services.NotificationServiceManager;
import jakarta.validation.Valid;
import java.time.LocalDateTime;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestParam;

@Controller
public class EmailNotificationController {
    private final NotificationServiceManager notificationServiceManager;
    private final NotificationRepository notificationRepository;
    private final DeviceSettingManagerService deviceSettingManagerService;

    @Autowired
    public EmailNotificationController(NotificationServiceManager notificationServiceManager, NotificationRepository notificationRepository, DeviceSettingManagerService deviceSettingManagerService) {
        this.notificationServiceManager = notificationServiceManager;
        this.notificationRepository = notificationRepository;
        this.deviceSettingManagerService = deviceSettingManagerService;
    }

    @GetMapping(value={"/emailnotification"})
    public String emailnotificationFunc(Model model, @RequestParam(required=false) Long id) {
        EmailNotification emailNotification;
        if (id == null) {
            id = 0L;
        }
        if ((emailNotification = this.notificationRepository.findById((Object)id).orElseGet(EmailNotification::new)).getLastSent() == null) {
            emailNotification.setLastSent(LocalDateTime.now().minusYears(1L));
        }
        if (emailNotification.getNotificationDelay() < 1) {
            emailNotification.setNotificationDelay(1);
        }
        model.addAttribute("emailnotification", (Object)emailNotification);
        model.addAttribute("notificationConditions", (Object)this.deviceSettingManagerService.loadAll());
        return "emailnotification";
    }

    @GetMapping(value={"/emailnotification/edit"})
    public String notificationEdit(Model model, @RequestParam(required=false) Long id, @RequestParam(required=false) boolean delete) {
        if (delete && id > 0L) {
            model.addAttribute("notificationConditions", (Object)this.deviceSettingManagerService.loadAll());
            this.notificationServiceManager.deleteEmailNotificationById(id);
            return "redirect:../notificationlist?deletesuccess=true";
        }
        return "redirect:../notificationlist?deletesuccess=false";
    }

    @PostMapping(value={"/emailnotification"})
    public String deviceSubmit(@Valid @ModelAttribute(value="emailnotification") EmailNotification emailNotification, BindingResult result, Model model) {
        model.addAttribute("emailnotification", (Object)emailNotification);
        model.addAttribute("notificationConditions", (Object)this.deviceSettingManagerService.loadAll());
        if (result.hasErrors()) {
            return "emailnotification";
        }
        if (emailNotification.getLastSent() == null) {
            emailNotification.setLastSent(LocalDateTime.now().minusYears(1L));
        }
        if (emailNotification.getNotificationDelay() < 1) {
            emailNotification.setNotificationDelay(1);
        }
        this.notificationServiceManager.saveEmailNotification(emailNotification);
        model.addAttribute("success", (Object)true);
        return "redirect:/notificationlist?success=true";
    }
}

