/*
 * Decompiled with CFR 0.152.
 */
package cz.snyll.sunny.controllers;

import cz.snyll.sunny.domain.CustomDashboardData;
import cz.snyll.sunny.repositories.CustomDashboardDataRepository;
import cz.snyll.sunny.services.CustomDashboardDataManagerService;
import jakarta.validation.Valid;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestParam;

@Controller
public class CustomDashboardDataController {
    private final CustomDashboardDataRepository customDashboardDataRepository;
    private final CustomDashboardDataManagerService customDashboardDataManagerService;

    @Autowired
    public CustomDashboardDataController(CustomDashboardDataRepository customDashboardDataRepository, CustomDashboardDataManagerService customDashboardDataManagerService) {
        this.customDashboardDataRepository = customDashboardDataRepository;
        this.customDashboardDataManagerService = customDashboardDataManagerService;
    }

    @GetMapping(value={"/customdashboarddata"})
    public String customdashboarddata(Model model, @RequestParam(required=false) Long id) {
        if (id == null) {
            id = 0L;
        }
        CustomDashboardData customDashboardData = this.customDashboardDataRepository.findById((Object)id).orElseGet(CustomDashboardData::new);
        model.addAttribute("customDashboardData", (Object)customDashboardData);
        return "customdashboarddata";
    }

    @GetMapping(value={"/customdashboarddata/edit"})
    public String customDashboardDataEdit(@RequestParam(required=false) Long id, @RequestParam(required=false) boolean delete) {
        if (delete && id > 0L) {
            this.customDashboardDataManagerService.deleteCustomDashboardDataById(id);
            return "redirect:../customdashboarddatalist?deletesuccess=true";
        }
        return "redirect:../customdashboarddatalist?deletesuccess=false";
    }

    @PostMapping(value={"/customdashboarddata"})
    public String deviceSubmit(@Valid @ModelAttribute CustomDashboardData customDashboardData, BindingResult result, Model model) {
        model.addAttribute("customdashboarddata", (Object)customDashboardData);
        if (result.hasErrors()) {
            return "customdashboarddata";
        }
        this.customDashboardDataManagerService.saveCustomDashboardData(customDashboardData);
        model.addAttribute("success", (Object)true);
        return "redirect:/customdashboarddatalist?success=true";
    }
}

