/*
 * Decompiled with CFR 0.152.
 */
package cz.snyll.sunny.controllers;

import cz.snyll.sunny.domain.MainConfiguration;
import cz.snyll.sunny.services.SunnyConfigurationService;
import jakarta.validation.Valid;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestParam;

@Controller
public class ConfigurationController {
    private final SunnyConfigurationService sunnyConfigurationService;

    @Autowired
    public ConfigurationController(SunnyConfigurationService sunnyConfigurationService) {
        this.sunnyConfigurationService = sunnyConfigurationService;
    }

    @GetMapping(value={"/configuration"})
    public String configuration(Model model, @RequestParam(required=false) boolean success, @RequestParam(required=false) boolean notconfigured) {
        MainConfiguration configuration = this.sunnyConfigurationService.loadIntoMainConfiguration();
        model.addAttribute("success", (Object)success);
        model.addAttribute("notconfigured", (Object)notconfigured);
        model.addAttribute("configuration", (Object)configuration);
        configuration.setPassword("");
        return "configuration";
    }

    @PostMapping(value={"/configuration"})
    public String configurationSubmit(@Valid @ModelAttribute(value="configuration") MainConfiguration configuration, BindingResult result, Model model) {
        model.addAttribute("configuration", (Object)configuration);
        if (result.hasErrors()) {
            return "configuration";
        }
        this.sunnyConfigurationService.saveAsMainConfiguration(configuration);
        model.addAttribute("success", (Object)true);
        return "redirect:/configuration?success=true";
    }
}

