/*
 * Decompiled with CFR 0.152.
 */
package cz.snyll.sunny.config;

import cz.snyll.sunny.convenience.NicePrinter;
import cz.snyll.sunny.services.SunnyConfigurationService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.http.HttpStatus;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.config.Customizer;
import org.springframework.security.config.annotation.authentication.builders.AuthenticationManagerBuilder;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.annotation.web.configuration.EnableWebSecurity;
import org.springframework.security.config.annotation.web.configurers.AbstractHttpConfigurer;
import org.springframework.security.config.annotation.web.configurers.AuthorizeHttpRequestsConfigurer;
import org.springframework.security.config.annotation.web.configurers.FormLoginConfigurer;
import org.springframework.security.core.userdetails.User;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.provisioning.InMemoryUserDetailsManager;
import org.springframework.security.web.AuthenticationEntryPoint;
import org.springframework.security.web.SecurityFilterChain;
import org.springframework.security.web.authentication.HttpStatusEntryPoint;
import org.springframework.security.web.util.matcher.AntPathRequestMatcher;
import org.springframework.security.web.util.matcher.RequestMatcher;

@Configuration
@EnableWebSecurity
public class BasicConfiguration {
    @Autowired
    private SunnyConfigurationService sunnyConfigurationService;

    @Bean
    public AuthenticationManager authenticationManager(HttpSecurity http) throws Exception {
        return (AuthenticationManager)((AuthenticationManagerBuilder)http.getSharedObject(AuthenticationManagerBuilder.class)).build();
    }

    @Bean
    public InMemoryUserDetailsManager userDetailsService() {
        String userName = this.sunnyConfigurationService.getSetting("user_name");
        String password = this.sunnyConfigurationService.getSetting("password");
        if (userName != null && !userName.isEmpty() && password != null && !password.isEmpty()) {
            UserDetails admin = User.withUsername((String)userName).password(password).authorities(new String[]{"ROLE_ADMIN"}).build();
            return new InMemoryUserDetailsManager(new UserDetails[]{admin});
        }
        return new InMemoryUserDetailsManager();
    }

    @Bean
    @Autowired
    public SecurityFilterChain filterChain(HttpSecurity http) throws Exception {
        System.out.println("SecurityFilterChain INITIALIZING...");
        String userName = this.sunnyConfigurationService.getSetting("user_name");
        if (userName != null && !userName.isEmpty()) {
            http.authorizeHttpRequests(authorize -> ((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)authorize.requestMatchers(new RequestMatcher[]{new AntPathRequestMatcher("/my_images/**"), new AntPathRequestMatcher("/getinfodata/**"), new AntPathRequestMatcher("/css/**"), new AntPathRequestMatcher("/vendor/**"), new AntPathRequestMatcher("/icons/**"), new AntPathRequestMatcher("/js/**"), new AntPathRequestMatcher("/getcollector/**")})).permitAll().anyRequest()).authenticated()).httpBasic(Customizer.withDefaults()).exceptionHandling(exception -> exception.defaultAuthenticationEntryPointFor((AuthenticationEntryPoint)new HttpStatusEntryPoint(HttpStatus.UNAUTHORIZED), (RequestMatcher)new AntPathRequestMatcher("/externalcollector/**"))).formLogin(formLogin -> ((FormLoginConfigurer)formLogin.loginPage("/login").defaultSuccessUrl("/", true)).permitAll()).rememberMe(Customizer.withDefaults());
        } else {
            NicePrinter.nicePrint((String)"No username setup in configuration file. No security being applied, access to everyone in the network is allowed.", (String)this.sunnyConfigurationService.getSetting("debug_mode"));
        }
        http.csrf(AbstractHttpConfigurer::disable);
        return (SecurityFilterChain)http.build();
    }
}

